package ru.yandex.partner.jsonapi.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.jsonapi.service.CommonResponseService;
import ru.yandex.partner.jsonapi.service.CrnkAdditionalDataService;

@RestController
public class DefaultsController  {

    private final CrnkAdditionalDataService crnkAdditionalDataService;
    private final CommonResponseService commonResponseService;

    public DefaultsController(CrnkAdditionalDataService crnkAdditionalDataService,
                              CommonResponseService commonResponseService) {
        this.crnkAdditionalDataService = crnkAdditionalDataService;
        this.commonResponseService = commonResponseService;
    }


    @GetMapping(value = "/v1/{resourceType}/defaults")
    public Object getDefaults(HttpServletRequest request,
                              HttpServletResponse response,
                              @PathVariable String resourceType) {
        var result = commonResponseService.commonResponse(request, response, resourceType);

        return crnkAdditionalDataService.getDefaults(result.getFirst(), result.getSecond());
    }
}
