package ru.yandex.partner.jsonapi.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.jsonapi.service.CommonResponseService;
import ru.yandex.partner.jsonapi.service.CrnkAdditionalDataService;

@RestController
public class DependsController {

    private final CrnkAdditionalDataService crnkAdditionalDataService;
    private final CommonResponseService commonResponseService;

    @Autowired
    public DependsController(CrnkAdditionalDataService crnkAdditionalDataService,
                             CommonResponseService commonResponseService) {
        this.crnkAdditionalDataService = crnkAdditionalDataService;
        this.commonResponseService = commonResponseService;
    }

    @GetMapping(value = "/v1/{resourceType}/depends")
    public Object getDepends(
            HttpServletRequest request,
            HttpServletResponse response,
            @PathVariable String resourceType
    ) {
        var result = commonResponseService
                .commonResponse(request, response, resourceType);

        return crnkAdditionalDataService.getDepends(result.getFirst(),
                result.getSecond().getApiService().getApiModel());
    }
}
