package ru.yandex.partner.jsonapi.controller;

import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.libs.auth.manager.DefaultPartnerAuthenticationManager;
import ru.yandex.partner.libs.auth.model.UserAuthenticationHolder;

@RestController
public class RootController {
    public static final String PATH = "root";
    private static final Logger LOGGER = LoggerFactory.getLogger(RootController.class);
    private static final String X_ACCEL_REDIRECT = "X-Accel-Redirect";
    private final DefaultPartnerAuthenticationManager manager;

    @Autowired
    public RootController(DefaultPartnerAuthenticationManager manager) {
        this.manager = manager;
    }

    @GetMapping(value = {"/" + PATH, "/" + PATH + "/{language}"})
    public void root(HttpServletRequest request,
                     HttpServletResponse response,
                     @PathVariable(required = false) String language) {
        try {
            Authentication authentication = manager.internalAuthenticate(new UserAuthenticationHolder(request));
            // todo автоматическое определение языка, когда будет готов лендинг локализованный
            if (authentication != null && authentication.isAuthenticated()) {
                makeRedirectToDashboard(response);
            } else {
                makeInternalRedirectToLanding(response, language);
            }
        } catch (AuthenticationException e) {
            makeInternalRedirectToLanding(response, language);
        } catch (Exception e) {
            LOGGER.error("Unexpected exception during authentication", e);
            makeInternalRedirectToLanding(response, language);
        }
    }

    private void makeInternalRedirectToLanding(HttpServletResponse response, @Nullable String language) {
        String path = "/promo";
        if (language != null) {
            path += "/" + language;
        }
        response.setStatus(HttpServletResponse.SC_OK);
        response.setHeader(X_ACCEL_REDIRECT, path);
    }

    private void makeRedirectToDashboard(HttpServletResponse response) {
        response.setStatus(HttpServletResponse.SC_MOVED_TEMPORARILY);
        response.setHeader("Location", "/v2/dashboard");
    }
}
