package ru.yandex.partner.jsonapi.controller;

import java.util.Map;

import org.jooq.tools.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.libs.extservice.moneymap.MoneyMapService;

@RestController
public class SuggestController {
    private final MoneyMapService moneyMapService;

    @Autowired
    public SuggestController(MoneyMapService moneyMapService) {
        this.moneyMapService = moneyMapService;
    }

    @GetMapping("/v1/api/suggest/abc")
    public Map<String, JSONObject> suggestAbc(
            @RequestParam(name = "text") String suggestTextPart,
            @RequestParam(required = false, defaultValue = "10") Integer limit,
            @RequestParam(name = "oebs", required = false, defaultValue = "false") Boolean isOebs
    ) {
        JSONObject jsonObject = moneyMapService.getSuggestAbc(suggestTextPart, limit, isOebs);
        return Map.of("data", jsonObject);
    }

    @GetMapping("/v1/api/suggest/abc/service")
    public Map<String, JSONObject> serviceAbc(@RequestParam(name = "abc_id") Integer abcID) {
        JSONObject jsonObject = moneyMapService.getServiceAbc(abcID);
        return Map.of("data", jsonObject);
    }
}
