package ru.yandex.partner.jsonapi.controller

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.bind.annotation.RestController
import ru.yandex.partner.core.entity.QueryOpts
import ru.yandex.partner.core.entity.user.filter.UserFilters
import ru.yandex.partner.core.entity.user.model.User
import ru.yandex.partner.core.entity.user.service.UserService
import ru.yandex.partner.core.filter.CoreFilterNode
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade
import ru.yandex.partner.libs.rbac.role.RoleSet
import java.io.IOException
import java.util.*
import javax.servlet.ServletException
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

@RestController
class UserController @Autowired constructor(
    private val authenticationFacade: AuthenticationFacade,
    private val userService: UserService) {

    @GetMapping("/v1/users/current")
    @Throws(ServletException::class, IOException::class)
    fun current(request: HttpServletRequest, response: HttpServletResponse?) {
        val requestDispatcher = request.getRequestDispatcher("/v1/users/" +
            authenticationFacade.userAuthentication.uid)
        requestDispatcher.forward(request, response)
    }

    @GetMapping("/v1/api/frontend/has_assistant_role")
    fun hasAssistantRole(@RequestParam login: String): Long {
        val optUser = userService.findAll(
            QueryOpts.forClass(User::class.java)
                .withFilter(UserFilters.LOGIN.eq(login))
                .withProps(setOf(User.ID, User.ROLES))
        ).stream().findFirst()
        if (optUser.isPresent) {
            val user = optUser.get()
            if ((Objects.nonNull(user.roles) && user.roles.contains(RoleSet.YAN_PARTNER_ASSISTANT))) {
                return user.id
            }
        }
        return 0L
    }
}
