package ru.yandex.partner.jsonapi.crnk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.crnk.core.resource.links.DefaultPagedLinksInformation;
import io.crnk.core.resource.links.Link;
import io.crnk.core.resource.links.SelfLinksInformation;

public class BaseCrnkLinksInformation extends DefaultPagedLinksInformation implements SelfLinksInformation {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Link self;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "add_fields")
    private String addField;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String related;

    @Override
    public Link getSelf() {
        return self;
    }

    @Override
    public void setSelf(Link self) {
        this.self = self;
    }

    public String getAddField() {
        return addField;
    }

    public void setAddField(String addField) {
        this.addField = addField;
    }

    public String getRelated() {
        return related;
    }

    public void setRelated(String related) {
        this.related = related;
    }
}
