package ru.yandex.partner.jsonapi.crnk;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.crnk.core.resource.meta.PagedMetaInformation;

import ru.yandex.partner.jsonapi.crnk.filter.description.FilterDescription;

public class BaseCrnkMetaInformation implements PagedMetaInformation {
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "found_rows")
    private Long totalResourceCount;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "count")
    private Long count;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "fields")
    private Collection<String> fields;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "can_view_other")
    private Boolean canViewOther;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "can_edit_other")
    private Boolean canEditOther;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "can_validate_design_as_manager")
    private Boolean canValidateDesignAsManager;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "filters")
    private List<FilterDescription> filterDescriptions;

    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Collection<String> getFields() {
        return fields;
    }

    public void setFields(Collection<String> fields) {
        this.fields = fields;
    }

    public Boolean getCanViewOther() {
        return canViewOther;
    }

    public void setCanViewOther(Boolean canViewOther) {
        this.canViewOther = canViewOther;
    }

    public Boolean getCanEditOther() {
        return canEditOther;
    }

    public void setCanEditOther(Boolean canEditOther) {
        this.canEditOther = canEditOther;
    }

    public Boolean getCanValidateDesignAsManager() {
        return canValidateDesignAsManager;
    }

    public void setCanValidateDesignAsManager(Boolean canValidateDesignAsManager) {
        this.canValidateDesignAsManager = canValidateDesignAsManager;
    }

    public List<FilterDescription> getFilterDescriptions() {
        return filterDescriptions;
    }

    public void setFilterDescriptions(List<FilterDescription> filterDescriptions) {
        this.filterDescriptions = filterDescriptions;
    }

    @Override
    public Long getTotalResourceCount() {
        return totalResourceCount;
    }

    @Override
    public void setTotalResourceCount(Long totalResourceCount) {
        this.totalResourceCount = totalResourceCount;
    }

}
