package ru.yandex.partner.jsonapi.crnk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import io.crnk.core.engine.filter.ResourceModificationFilterBase;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.information.resource.ResourceField;
import org.springframework.stereotype.Component;

@Component
public class CrnkResourceModificationFilter extends ResourceModificationFilterBase implements HttpRequestContextAware {
    private HttpRequestContextProvider requestContextProvider;

    @Override
    public <T> T modifyAttribute(Object resource, ResourceField field, String fieldName, T value) {
        if (value instanceof IOException) {
            HttpRequestContext httpRequestContext = requestContextProvider.getRequestContext();

            Object fieldsWithJsonParseError =
                    httpRequestContext.getRequestAttribute("fieldsWithJsonParseError");

            if (fieldsWithJsonParseError == null) {
                fieldsWithJsonParseError = new HashMap<String, Class<?>>();
            }

            if (fieldsWithJsonParseError instanceof Map) {
                ((Map<String, Class<?>>) fieldsWithJsonParseError).put(fieldName, field.getType());

                httpRequestContext.setRequestAttribute("fieldsWithJsonParseError", fieldsWithJsonParseError);
            } else {
                throw new IllegalStateException("fieldsWithJsonParseError must be a map");
            }

            return null;
        }

        return value;
    }

    @Override
    public void setHttpRequestContextProvider(HttpRequestContextProvider requestContextProvider) {
        this.requestContextProvider = requestContextProvider;
    }
}
