package ru.yandex.partner.jsonapi.crnk;

import java.util.List;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.filter.AbstractDocumentFilter;
import io.crnk.core.engine.filter.DocumentFilterChain;
import io.crnk.core.engine.filter.DocumentFilterContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.jsonapi.crnk.exceptions.ValidationException;
import ru.yandex.partner.jsonapi.messages.JacksonDataValidationMsg;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;
import ru.yandex.partner.libs.i18n.MsgWithArgs;
import ru.yandex.partner.libs.i18n.TranslatableError;

@Component
public class CustomDocumentValidationCrnkFilter extends AbstractDocumentFilter {

    private static final String PATCH = "PATCH";
    private static final String POST = "POST";

    @Override
    public Response filter(DocumentFilterContext context, DocumentFilterChain chain) {
        validateNecessaryFields(context);
        return chain.doFilter(context);
    }

    private void validateNecessaryFields(DocumentFilterContext context) {
        Document document = context.getRequestBody();
        String method = context.getMethod();
        String typeFromUrl = context.getQueryAdapter().toQuerySpec().getResourceType();
        if (document != null && document.getSingleData().isPresent()) {
            Resource resource = document.getSingleData().get();
            String id = resource.getId();
            String type = resource.getType();
            if (PATCH.equals(method) || POST.equals(method)) {
                if (type == null) {
                    throw new ValidationException(List.of(
                            new TranslatableError("/data/type",
                                    MsgWithArgs.of(JacksonDataValidationMsg.EXPECTED_TYPE))
                    ));
                }
                if (!type.equals(typeFromUrl)) {
                    throw new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__CONFLICT,
                            List.of(
                                    new TranslatableError("/data/type",
                                            MsgWithArgs.of(JacksonDataValidationMsg.INCORRECT_TYPE))
                            ));
                }
            }
            if (PATCH.equals(method)) {
                if (id == null) {
                    throw new ValidationException(List.of(
                            new TranslatableError("/data/id",
                                    MsgWithArgs.of(JacksonDataValidationMsg.EXPECTED_ID))
                    ));
                }

                if (!id.equals(context.getJsonPath().getId())) {
                    throw new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__CONFLICT,
                            List.of(
                                    new TranslatableError("/data/id",
                                            MsgWithArgs.of(JacksonDataValidationMsg.INCORRECT_ID))
                            ));
                }
            }
        }
    }
}
