package ru.yandex.partner.jsonapi.crnk;

import java.util.Map;
import java.util.Set;

import io.crnk.core.queryspec.FilterSpec;

public class CustomParametersHolder extends FilterSpec {

    private boolean isTotalRequested = false;

    private Map<String, Set<String>> originalParameters;

    public boolean isTotalRequested() {
        return isTotalRequested;
    }

    public void setTotalRequested() {
        isTotalRequested = true;
    }

    public Map<String, Set<String>> getOriginalParameters() {
        return originalParameters;
    }

    public void setOriginalParameters(Map<String, Set<String>> originalParameters) {
        this.originalParameters = originalParameters;
    }

    @Override
    public FilterSpec clone() {
        CustomParametersHolder customParametersHolder = new CustomParametersHolder();
        if (isTotalRequested()) {
            customParametersHolder.setTotalRequested();
        }
        customParametersHolder.setOriginalParameters(getOriginalParameters());
        return customParametersHolder;
    }

}
