package ru.yandex.partner.jsonapi.crnk;

import java.util.List;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.queryspec.internal.DefaultQueryPathResolver;
import io.crnk.core.queryspec.mapper.QueryPathSpec;

/**
 * Этот объект предназначен для того, чтобы перегонять имена полей из json-овского snake_case
 * в джавовский camelCase и обратно.
 * Нас устраивает json-нотация на всех этапах, поэтому этот ресолвер всегда гоняет из json в json
 */
public class CustomQueryPathResolver extends DefaultQueryPathResolver {

    public CustomQueryPathResolver() {
        setMapJsonNames(false);
    }

    @Override
    public QueryPathSpec resolve(ResourceInformation resourceInformation, List<String> attributePath,
                                 NamingType sourceNamingType, String sourceParameter, QueryContext queryContext) {
        return super.resolve(resourceInformation, attributePath, NamingType.JSON, sourceParameter, queryContext);
    }

}
