package ru.yandex.partner.jsonapi.crnk;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.jsonapi.crnk.authorization.actions.AbstractActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionAuthEntry;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.libs.auth.facade.UserAuthenticationProvider;

@ParametersAreNonnullByDefault
public class DummyActionAllowedAuthorizationService<M> extends AbstractActionsAuthorizationService<M> {

    public DummyActionAllowedAuthorizationService(UserAuthenticationProvider userAuthenticationProvider,
                                                  ApiModelMetaData<M>  apiModelMetaData) {
        super(null, apiModelMetaData, userAuthenticationProvider, List.of());
    }

    @Override
    protected Map<String, ActionAuthEntry<M>> getAuthEntryMap() {
        return Map.of();
    }

    @Override
    public boolean checkActionAllowedAndAuthorized(String actionName, M coreModel) {
        return true;
    }
}
