package ru.yandex.partner.jsonapi.crnk;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import io.crnk.core.engine.document.Resource;


/**
 * Вариант crnk-ресурса, в котором поле attributes всегда сериализуется.
 */
public class PatchedResource extends Resource {

    public PatchedResource() {
        super();
    }

    public PatchedResource(Resource originalResource) {
        super();
        this.setId(originalResource.getId());
        this.setType(originalResource.getType());
        this.setAttributes(originalResource.getAttributes());
        this.setRelationships(originalResource.getRelationships());
        this.setLinks(originalResource.getLinks());
        this.setMeta(originalResource.getMeta());
    }

    @Override
    @JsonGetter
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public Map<String, JsonNode> getAttributes() {
        return super.getAttributes();
    }

}
