package ru.yandex.partner.jsonapi.crnk.action.check;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Lists;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Aбстрактный класс компоновщик для проверок Action.
 * Для реализации проверок для модели необходимо
 * реализовать этот класс с маркeрным интерфейсом унаследованным от ActionChecker
 */
@ParametersAreNonnullByDefault
public class AbstractCheckerComposite<M extends Model, K extends ActionChecker<M>> implements CheckerComposite<M> {
    private final Map<Class<?>, K> checks;
    private final Set<ModelProperty<? super M, ?>> properties;

    public AbstractCheckerComposite(List<K> checks) {
        this.checks = checks.stream().collect(Collectors.toMap(K::getClass, bean -> bean));
        this.properties = checks.stream().flatMap(entry ->
                entry.getRequiredProperties().stream()).collect(Collectors.toSet());
    }

    @Override
    public K getCheckByName(ActionCheckClassName checkName) {
        var check = checks.getOrDefault(checkName.getClassName(), null);
        if (Objects.isNull(check)) {
            throw new IllegalArgumentException(String.format("Action check bean %s doesn't exist in composite class",
                    checkName.getClassName().getSimpleName()));
        }
        return check;
    }

    @Override
    public List<ModelProperty<? super M, ?>> getAllRequiredProperties() {
        return Lists.newArrayList(properties);
    }

}
