package ru.yandex.partner.jsonapi.crnk.action.check;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype.MobileShowVideoApplicableService;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

@Component
public class UserSimpleInappActionChecker implements ActionChecker<MobileRtbBlock> {
    private final MobileShowVideoApplicableService applicableService;

    public UserSimpleInappActionChecker(MobileShowVideoApplicableService applicableService) {
        this.applicableService = applicableService;
    }

    @Override
    public <S extends MobileRtbBlock> List<Boolean> check(UserAuthentication ua, String modelName, List<S> coreModels) {
        return coreModels.stream()
                .map(b -> Boolean.FALSE.equals(applicableService.isSimpleInappByCampaignOwner(b)))
                .toList();
    }

    @Override
    public List<ModelProperty<? super MobileRtbBlock, ?>> getRequiredProperties() {
        return List.of(MobileRtbBlock.CAMPAIGN);
    }
}
