package ru.yandex.partner.jsonapi.crnk.authorization;

import java.util.function.Supplier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.libs.authorization.decision.DecisionMatcher;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;

public final class AuthorizationDecisionMatchers {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationDecisionMatchers.class);

    private AuthorizationDecisionMatchers() {
        // utility
    }

    public static <T> DecisionMatcher<T, Void> permittedOrElseThrow(HttpErrorStatusEnum orStatus) {
        return permittedOrElseThrow(() -> new CrnkResponseStatusException(orStatus));
    }

    public static <T> DecisionMatcher<T, Void> permittedOrElseThrow() {
        return permittedOrElseThrow(() -> new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__FORBIDDEN));
    }

    public static <T> DecisionMatcher<T, Void> permittedOrElseThrow(Supplier<RuntimeException> exception) {
        return new DecisionMatcher<>() {
            @Override
            public Void unapplicable(Boolean unapplicable) {
                throw exception.get();
            }

            @Override
            public Void permit(Boolean permit) {
                return null;
            }

            @Override
            public Void restrictedPermit(CoreFilterNode<T> x) {
                return null;
            }

            @Override
            public Void deny(String deny) {
                // TODO: 30.03.2022 отдавать сообщение в апи?
                LOGGER.debug(deny);
                throw exception.get();
            }
        };
    }
}
