package ru.yandex.partner.jsonapi.crnk.authorization.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;

public class ActionAuthEntry<M> {
    private final String rightPrefix;
    private final String actionName;
    private final boolean isExposed;
    private final boolean isRightRequired;
    private final List<ActionChecker<? super M>> checks;

    public ActionAuthEntry(String rightPrefix, String actionName, boolean isExposed, boolean isRightRequired,
                           List<ActionChecker<? super M>>  checks) {
        this.rightPrefix = rightPrefix;
        this.actionName = actionName;
        this.isExposed = isExposed;
        this.isRightRequired = isRightRequired;
        this.checks = checks;
    }

    public String getRightPrefix() {
        return rightPrefix;
    }

    public String getActionName() {
        return actionName;
    }

    public boolean isExposed() {
        return isExposed;
    }

    public boolean isRightRequired() {
        return isRightRequired;
    }

    public List<ActionChecker<? super M>> getChecks() {
        return checks;
    }

    public static <M> Map<String, ActionAuthEntry<M>> buildMap(
            String rightPrefix,
            List<ActionAuthEntry.Builder<M>> builders
    ) {
        HashMap<String, ActionAuthEntry<M>> map = new HashMap<>();

        for (var builder : builders) {
            builder.setRightPrefix(rightPrefix);
            var entry = builder.build();
            map.put(entry.actionName, entry);
        }

        return map;
    }

    public static <M> ActionAuthEntry.Builder<M> builder() {
        return new ActionAuthEntry.Builder<>();
    }

    public static class Builder<M> {
        private String rightPrefix;
        private String actionName;
        private boolean isExposed;
        private boolean isRightRequired;
        private List<ActionChecker<? super M>> checks;

        public Builder() {

        }

        public Builder<M> setRightPrefix(String rightPrefix) {
            this.rightPrefix = rightPrefix;
            return this;
        }

        public Builder<M> setActionName(ActionNameHolder actionNameHolder) {
            this.actionName = actionNameHolder.getActionName();
            return this;
        }

        public Builder<M> setExposed(boolean exposed) {
            isExposed = exposed;
            return this;
        }

        public Builder<M> setRightRequired(boolean rightRequired) {
            isRightRequired = rightRequired;
            return this;
        }

        public Builder<M> setChecks(List<ActionChecker<? super M>> checks) {
            this.checks = checks;
            return this;
        }

        ActionAuthEntry<M> build() {
            return new ActionAuthEntry<>(rightPrefix, actionName, isExposed, isRightRequired, checks);
        }
    }

}
