package ru.yandex.partner.jsonapi.crnk.authorization.actions;

import java.util.List;

import ru.yandex.partner.libs.auth.model.UserAuthentication;

public interface ActionAuthHook<M> {
    List<Boolean> isAuthorizedToBePerformed(UserAuthentication ua, List<M> models);

    default Boolean isAuthorizedToBePerformed(UserAuthentication ua, M model) {
        return isAuthorizedToBePerformed(ua, List.of(model)).get(0);
    }
}
