package ru.yandex.partner.jsonapi.crnk.authorization.actions;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.Action;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;

@ParametersAreNonnullByDefault
public interface ActionsAuthorizationService<M> {
    List<Boolean> checkActionAuthorized(String actionName, List<M> coreModels);

    /**
     * just redirect to {@link #checkActionAuthorized(String, List)}
     */
    default List<Boolean> checkActionAuthorized(
            ActionNameHolder actionNameHolder, List<M> coreModels) {
        return checkActionAuthorized(actionNameHolder.getActionName(), coreModels);
    }

    boolean checkActionAuthorized(String actionName, M coreModel);

    /**
     * just redirect to {@link #checkActionAuthorized(String, M)}
     */
    default boolean checkActionAuthorized(ActionNameHolder actionNameHolder, M coreModel) {
        return checkActionAuthorized(actionNameHolder.getActionName(), coreModel);
    }

    boolean checkActionAllowedAndAuthorized(String actionName, M coreModel);

    // TODO используется только в тесте
    Map<String, String> getRightNamesForActions();

    boolean isActionExposed(String actionName);

    List<ModelProperty<? super M, ?>> getAllRequiredProperties();

    Set<ModelProperty<? extends Model, ?>> getRequiredPropertiesByAction(ActionNameHolder actionNameHolder);

    Set<Action> filterApiActions(M model, Set<Action> allowedActions);
}
