package ru.yandex.partner.jsonapi.crnk.authorization.request;

import org.springframework.stereotype.Component;

import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;

@Component
public class RequestAuthorizationService implements RequestAuthenticationProvider {
    private final AuthenticationFacade authenticationFacade;

    public RequestAuthorizationService(AuthenticationFacade authenticationFacade) {
        this.authenticationFacade = authenticationFacade;
    }

    @Override
    public RequestContext currentRequestContext() {
        return new RequestContext(getUserAuthentication());
    }

    @Override
    public AuthenticationFacade getAuthenticationFacade() {
        return authenticationFacade;
    }

    @Override
    public UserAuthentication getUserAuthentication() {
        return authenticationFacade.getUserAuthentication();
    }

    @Override
    public boolean userHasRight(String rightName) {
        return authenticationFacade.userHasRight(rightName);
    }
}
