package ru.yandex.partner.jsonapi.crnk.block.authorization.actions;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;

@ParametersAreNonnullByDefault
public interface BlockActionsCheckers<B extends BaseBlock> {
    List<ActionChecker<? super B>> delete();

    List<ActionChecker<? super B>> restore();

    List<ActionChecker<? super B>> edit();

    List<ActionChecker<? super B>> duplicate();

    default List<ModelProperty<? super B, ?>> getAllRequiredFields() {
        var baseCheckers = List.of(delete(), restore(), edit(), duplicate());


        return Stream.of(baseCheckers, addToRequiredFields())
                .flatMap(List::stream)
                .flatMap(List::stream)
                .map(ActionChecker::getRequiredProperties)
                .flatMap(List::stream)
                .distinct()
                .collect(Collectors.toList());
    }

    default List<List<ActionChecker<? super B>>> addToRequiredFields() {
        return List.of();
    }

}
