package ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.NotGeneratedBlockWithPageWithOwner;
import ru.yandex.partner.core.entity.block.model.BlockWithPageWithOwner;
import ru.yandex.partner.core.entity.page.model.PageWithAssistants;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.crnk.page.PageComputableApiFieldsService;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

public abstract class BaseNotReadOnlyAssistantChecker<B extends BlockWithPageWithOwner> implements ActionChecker<B> {
    protected final PageComputableApiFieldsService pageComputableApiFieldsService;

    public BaseNotReadOnlyAssistantChecker(PageComputableApiFieldsService pageComputableApiFieldsService) {
        this.pageComputableApiFieldsService = pageComputableApiFieldsService;
    }

    @Override
    public <S extends B>
    List<Boolean> check(UserAuthentication ua, String modelName, List<S> coreModels) {
        return coreModels.stream()
                .map(model -> getPageForBlock(model.getId(), model))
                .map(page -> !(page instanceof PageWithAssistants pwa) || !isCurUserReadOnlyAssistant(pwa))
                .collect(Collectors.toList());
    }

    @Override
    public abstract List<ModelProperty<? super B, ?>> getRequiredProperties();

    private PageWithOwner getPageForBlock(Long id, NotGeneratedBlockWithPageWithOwner model) {
        if (model.getCampaign() == null) {
            throw new IllegalStateException("Page not loaded for block " + id);
        }
        return model.getCampaign();
    }

    private boolean isCurUserReadOnlyAssistant(PageWithAssistants page) {
        if (page.getAssistants() == null) {
            throw new IllegalStateException("Assistants not loaded for page " + page.getId());
        }
        return pageComputableApiFieldsService.curUserIsReadAssistant(page.getAssistants());
    }
}
