package ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkData;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

import static ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder.IS_CUSTOM_BK_DATA;

@ParametersAreNonnullByDefault
@Component
public class BlockIsGodModeChecker implements ActionChecker<BlockWithCustomBkData> {

    @Override
    public <S extends BlockWithCustomBkData>
    List<Boolean> check(UserAuthentication ua, String modelName, List<S> coreModels) {

        String rightName = BlockRightNames.EDIT_FIELD__BK_DATA.getFullRightName(modelName);
        return coreModels.stream()
                .map((model) -> !(model.getIsCustomBkData() && !ua.userHasRight(rightName)))
                .collect(Collectors.toList());
    }

    @Override
    public List<ModelProperty<? super BlockWithCustomBkData, ?>> getRequiredProperties() {
        return List.of(IS_CUSTOM_BK_DATA);
    }
}

