package ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.BlockWithReadonly;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;


@Component
@ParametersAreNonnullByDefault
public class BlockNotReadOnlyOrUserCanEditReadOnlyChecker implements ActionChecker<BlockWithReadonly> {

    @Override
    public <S extends BlockWithReadonly> List<Boolean> check(UserAuthentication ua,
                                                             String modelName,
                                                             List<S> coreModels) {

        if (ua.userHasRight(BlockRightNames.EDIT_FIELD__READONLY.getFullRightName(modelName))) {
            return Collections.nCopies(coreModels.size(), true);
        }
        return coreModels.stream().map(model -> !isReadOnly(model)).collect(Collectors.toList());
    }

    @Override
    public List<ModelProperty<? super BlockWithReadonly, ?>> getRequiredProperties() {
        return List.of(BlockWithReadonly.READONLY);
    }

    private Boolean isReadOnly(BlockWithReadonly model) {
        return Boolean.TRUE.equals(model.getReadonly());
    }
}
