package ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;


@Component
@ParametersAreNonnullByDefault
public class CanAddBlockChecker<B extends BaseBlock> implements ActionChecker<B> {

    @Override
    public <S extends B> List<Boolean> check(UserAuthentication ua, String modelName, List<S> coreModels) {
        return Collections.nCopies(coreModels.size(), ua.userHasRight(BlockRightNames.ADD.getFullRightName(modelName)));
    }

    @Override
    public List<ModelProperty<? super B, ?>> getRequiredProperties() {
        return List.of();
    }
}
