package ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.jsonapi.crnk.page.PageComputableApiFieldsService;

@ParametersAreNonnullByDefault
@Component
public class MobileRtbNotReadOnlyAssistantChecker extends BaseNotReadOnlyAssistantChecker<MobileRtbBlock> {

    @Autowired
    public MobileRtbNotReadOnlyAssistantChecker(PageComputableApiFieldsService pageComputableApiFieldsService) {
        super(pageComputableApiFieldsService);
    }

    @Override
    public List<ModelProperty<? super MobileRtbBlock, ?>> getRequiredProperties() {
        return List.of(MobileRtbBlock.CAMPAIGN);
    }

}
