package ru.yandex.partner.jsonapi.crnk.block.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;

import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.AbstractDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.IgnorableFilterParserException;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.CrnkFilterValueParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.DefaultCrnkFilterValueParser;
import ru.yandex.partner.jsonapi.utils.MergeUtils;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class SiteVersionValueParserAndProvider extends AbstractDictionaryValuesProvider<String>
        implements CrnkFilterValueParser<String> {

    private final DefaultCrnkFilterValueParser<String> valueParser = new DefaultCrnkFilterValueParser<>(String.class);
    private final MessageSourceAccessor messageSource;
    private final SortedMap<String, GettextMsg> valuesMap;

    public SiteVersionValueParserAndProvider(
            MessageSource messageSource,
            Set<SiteVersionType> siteVersionTypeSet
    ) {
        this.messageSource = new MessageSourceAccessor(messageSource);
        TreeMap<String, GettextMsg> map = siteVersionTypeSet.stream()
                .collect(Collectors.toMap(
                        SiteVersionType::getLiteral,
                        SiteVersionType::getGettextMsg,
                        MergeUtils.uniqMerge(),
                        TreeMap::new
                ));

        valuesMap = Collections.unmodifiableSortedMap(map);
    }

    @Override
    public Collection<String> toValues(JsonNode node) throws IgnorableFilterParserException {
        Collection<String> collection = valueParser.toValues(node);
        HashSet<String> set = new HashSet<>(collection);

        if (set.contains(SiteVersionType.GENERAL.getLiteral())) {
            set.remove(SiteVersionType.GENERAL.getLiteral());
            set.add(SiteVersionType.DESKTOP.getLiteral());
            set.add(SiteVersionType.MOBILE.getLiteral());
        }
        return set;
    }

    @Override
    protected SortedMap<String, GettextMsg> getValues() {
        return valuesMap;
    }

    public String getSiteVersionLabel(String siteVersionName) {
        return messageSource.getMessage(valuesMap.get(siteVersionName));
    }
}
