package ru.yandex.partner.jsonapi.crnk.block.filter.parser;

import java.util.Collection;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.filter.dbmeta.models.PublicIdFilterModel;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.IgnorableFilterParserException;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.CrnkFilterValueParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.DefaultCrnkFilterValueParser;

public class BlockIdValueParser implements CrnkFilterValueParser<PublicIdFilterModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockIdValueParser.class);

    private final CrnkFilterValueParser<String> valueParser =
            new DefaultCrnkFilterValueParser<>(String.class);
    private final BlockUniqueIdConverter.Prefixes prefix;

    public BlockIdValueParser(BlockUniqueIdConverter.Prefixes prefix) {
        this.prefix = prefix;
    }

    @Override
    public Collection<PublicIdFilterModel> toValues(JsonNode node) throws IgnorableFilterParserException {
        Collection<String> values = valueParser.toValues(node);

        return values.stream()
                .map(publicId -> new PublicIdFilterModel(prefix, publicId))
                .collect(Collectors.toList());
    }



}
