package ru.yandex.partner.jsonapi.crnk.block.filter.provider;

import java.util.Collections;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.AbstractDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.utils.MergeUtils;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class BlockTypeValuesProvider extends AbstractDictionaryValuesProvider<String> {
    private SortedMap<String, GettextMsg> values;

    public BlockTypeValuesProvider(Set<MobileBlockType> supportedBlockTypes) {
        var sortedMap = supportedBlockTypes.stream().collect(Collectors.toMap(
                MobileBlockType::getLiteral,
                MobileBlockType::getMsg,
                MergeUtils.uniqMerge(),
                TreeMap::new
        ));
        this.values = Collections.unmodifiableSortedMap(sortedMap);
    }

    @Override
    protected SortedMap<String, GettextMsg> getValues() {
        return values;
    }
}
