package ru.yandex.partner.jsonapi.crnk.block.filter.provider;

import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.page.MobileStoreType;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.AbstractDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.messages.block.RtbMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

@Component
public class MobilePlatformDictionaryProvider extends AbstractDictionaryValuesProvider<Long> {
    // не хотел затаскивать в кор енум с переводами, так что тут будет мапка
    private final SortedMap<Long, GettextMsg> platforms;

    public MobilePlatformDictionaryProvider() {
        SortedMap<Long, GettextMsg> map = new TreeMap<>(Long::compare);
        map.put(MobileStoreType.ANDROID.getId(), RtbMsg.ANDROID);
        map.put(MobileStoreType.IOS.getId(), RtbMsg.IOS);

        this.platforms = Collections.unmodifiableSortedMap(map);
    }

    @Override
    protected SortedMap<Long, GettextMsg> getValues() {
        return platforms;
    }
}
