package ru.yandex.partner.jsonapi.crnk.block.filter.provider;

import java.util.Comparator;
import java.util.TreeMap;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.jsonapi.messages.StrategyMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class MobileStrategyDictionaryValueProvider extends StrategyDictionaryValueProvider {

    private static TreeMap<Long, GettextMsg> strategies = new TreeMap<Long, GettextMsg>(
            Comparator.comparing(id -> PRIORITY.getOrDefault(id, DEFAULT_PRIORITY)));
    static {
        strategies.put(CoreConstants.Strategies.MIN_CPM_STRATEGY_ID, StrategyMsg.MINIMUM_CPM);
        strategies.put(CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID, StrategyMsg.MAXIMUM_REVENUE);
    }

    public MobileStrategyDictionaryValueProvider() {
       super(strategies);
    }
}
