package ru.yandex.partner.jsonapi.crnk.block.filter.provider;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.AbstractDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.messages.StrategyMsg;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class StrategyDictionaryValueProvider extends AbstractDictionaryValuesProvider<Long> {
    // Для сортировки как перле
    // Использовал 100 и т.д. чтобы не было ассоциации с id стратегии
    protected static final Map<Long, Long> PRIORITY = Map.of(
            CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID, 100L,
            CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID, 200L,
            CoreConstants.Strategies.MIN_CPM_STRATEGY_ID, 300L
    );
    protected static final Long DEFAULT_PRIORITY = 1000L;

    private final SortedMap<Long, GettextMsg> values;

    public StrategyDictionaryValueProvider() {
        TreeMap<Long, GettextMsg> strategies = new TreeMap<Long, GettextMsg>(
                Comparator.comparing(id -> PRIORITY.getOrDefault(id, DEFAULT_PRIORITY)));
            strategies.put(CoreConstants.Strategies.MIN_CPM_STRATEGY_ID, StrategyMsg.MINIMUM_CPM);
            strategies.put(CoreConstants.Strategies.MAX_REVENUE_STRATEGY_ID, StrategyMsg.MAXIMUM_REVENUE);
            strategies.put(CoreConstants.Strategies.SEPARATE_CPM_STRATEGY_ID, StrategyMsg.SEPARATE_CPM);
        values = Collections.unmodifiableSortedMap(strategies);
    }

    protected StrategyDictionaryValueProvider(TreeMap<Long, GettextMsg> strategies) {
        values = Collections.unmodifiableSortedMap(strategies);
    }


    @Override
    public SortedMap<Long, GettextMsg> getValues() {
        return values;
    }
}
