package ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.authorization.policy.contextual.GetRequestPolicy;

public abstract class AbstractBlockByPageRule<T extends BaseBlock> implements BlockByPageRule<T> {

    private final GetRequestPolicy<BasePage> getRequestPolicy;

    public AbstractBlockByPageRule(GetRequestPolicy<? extends BasePage> getRequestPolicy) {
        //noinspection unchecked
        this.getRequestPolicy = (GetRequestPolicy<BasePage>) getRequestPolicy;
    }

    public AuthorizationDecision<T> authorize(RequestContext getRequest) {
        var authorizationDecision = getRequestPolicy.authorizeGetRequest(getRequest);
        return authorizationDecision.match(
                unapplicable -> AuthorizationDecision.unapplicable(),
                permit -> AuthorizationDecision.permit(),
                restrictedPermit -> AuthorizationDecision.restrictedPermit(CoreFilterNode.create(
                        BlockFilters.PAGE,
                        FilterOperator.MATCH,
                        restrictedPermit
                )),
                AuthorizationDecision::deny
        );
    }
}
