package ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class ActiveBlockRule {

    public <T extends BaseBlock> AuthorizationDecision<T> authorize() {
        return AuthorizationDecision.restrictedPermit(
                // Можно вместо NOT_EQUALS false сделать EQUALS true,
                // но так сделано в перл, предполагаю так быстрее работает
                CoreFilterNode.create(
                        BlockFilters.ACTIVE,
                        FilterOperator.NOT_EQUALS,
                        false
                )
        );
    }
}
