package ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class BlockViewRule {
    public <T extends BaseBlock> AuthorizationDecision<T> authorize(String modelName, UserAuthentication ua) {
        String rightName = BlockRightNames.VIEW.getFullRightName(modelName);
        return ua.userHasRight(rightName)
                ? AuthorizationDecision.unapplicable()
                : AuthorizationDecision.deny("User does not have right " + rightName);
    }
}
