package ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class TechnicalBlockRule {
    public <T extends BaseBlock> AuthorizationDecision<T> authorize(String modelName, UserAuthentication ua) {
        if (ua.userHasRight(BlockRightNames.VIEW_TECHNICAL_RTB_BLOCK.getFullRightName(modelName))) {
            return AuthorizationDecision.permit();
        }

        return AuthorizationDecision.restrictedPermit(
                CoreFilterNode.create(
                        BlockFilters.BLOCK_ID,
                        FilterOperator.NOT_EQUALS,
                        CoreConstants.TECHNICAL_RTB_BLOCK_ID
                )
        );
    }
}
