package ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class DenyAddByMRuText {
    public <T extends BaseBlock> AuthorizationDecision<T> authorize(RequestContext createRequest) {
        UserAuthentication userAuthentication = createRequest.getUserAuthentication();
        if (userAuthentication.getUid() == CoreConstants.M_RU_TEXT_USER_ID) {
            return AuthorizationDecision.deny("M_RU_TEXT_USER_ID has not access to add RTB. ");
        } else {
            return AuthorizationDecision.permit();
        }
    }
}
