package ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Component
public class HasAddRule {
    public <T extends BaseBlock> AuthorizationDecision<T> authorize(String modelName, RequestContext createRequest) {
        UserAuthentication userAuthentication = createRequest.getUserAuthentication();
        if (!userAuthentication.userHasRight(BlockRightNames.ADD.getFullRightName(modelName))) {
            return AuthorizationDecision.deny("User has not right to add RTB. user_id = " +
                    userAuthentication.getUid());
        } else {
            return AuthorizationDecision.permit();
        }
    }
}
