package ru.yandex.partner.jsonapi.crnk.block.rtb.external;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ForeignFieldDefaultsService;
import ru.yandex.partner.jsonapi.models.block.BlockAccessFunctionComposite;
import ru.yandex.partner.jsonapi.models.block.rtb.external.ApiRtbModel;

import static ru.yandex.partner.core.entity.block.model.prop.BaseBlockIdPropHolder.ID;

@Service
public class RtbBlockApiFieldsService extends ApiFieldsService<RtbBlock> {

    private final BlockValidationTypeSupportFacade blockValidationTypeSupportFacade;

    @Autowired
    public RtbBlockApiFieldsService(ApiRtbModel apiRtbModel,
                                    BlockAccessFunctionComposite<RtbBlock> functions,
                                    List<ForeignFieldDefaultsService<RtbBlock>> foreignFieldDefaultsServiceList,
                                    BlockValidationTypeSupportFacade blockValidationTypeSupportFacade) {
        super(apiRtbModel.getApiFieldsAvailableRules(), apiRtbModel.getApiFieldsEditableRules(), apiRtbModel,
                CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME,
                CrnkConstants.EDITABLE_FIELDS_FIELD_NAME,
                functions,
                foreignFieldDefaultsServiceList
        );
        this.blockValidationTypeSupportFacade = blockValidationTypeSupportFacade;
    }

    @Override
    public ModelProperty<? super RtbBlock, ?> getId() {
        return ID;
    }

    @Override
    public Set<ModelProperty<?, ?>> getPropertiesForValidate(Set<ModelProperty<?, ?>> affectedFields) {
        return blockValidationTypeSupportFacade.getPropertiesForValidate(
                affectedFields,
                getApiModel().getModelClass()
        );
    }
}
