package ru.yandex.partner.jsonapi.crnk.block.rtb.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.model.PageWithMultistate;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.BlockAuthorizationPolicy;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.ActiveBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.BlockViewRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.RtbBlockByPageRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.TechnicalBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.ZeroBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post.DenyAddByMRuText;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post.EditProtectedPageRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post.HasAddRule;
import ru.yandex.partner.jsonapi.models.block.rtb.external.ApiRtbMetaData;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

@Service
public class RtbBlockAuthorizationPolicy extends BlockAuthorizationPolicy<RtbBlock> {
    private final DenyAddByMRuText denyAddByMRuText;


    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public RtbBlockAuthorizationPolicy(
            ApiRtbMetaData apiRtbMetaData,
            BlockViewRule blockViewRule,
            ActiveBlockRule activeBlockRule,
            RtbBlockByPageRule rtbBlockByPageRule,
            TechnicalBlockRule technicalBlockRule,
            ZeroBlockRule zeroBlockRule,
            HasAddRule hasAddRule,
            DenyAddByMRuText denyAddByMRuText,
            EditProtectedPageRule editProtectedPageRule
    ) {
        super(
                apiRtbMetaData,
                blockViewRule,
                activeBlockRule,
                rtbBlockByPageRule,
                technicalBlockRule,
                zeroBlockRule,
                hasAddRule,
                editProtectedPageRule
        );
        this.denyAddByMRuText = denyAddByMRuText;
    }

    @Override
    public AuthorizationDecision<RtbBlock> authorizeCreateRequest(RequestContext createRequest) {
        return AuthorizationDecision.denyOverrides(
                super.authorizeCreateRequest(createRequest),
                denyAddByMRuText.authorize(createRequest)
        );
    }

    @Override
    public Class<? extends PageWithMultistate> getPageClass() {
        return ContextPage.class;
    }
}
