package ru.yandex.partner.jsonapi.crnk.block.rtb.external.authorization.actions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsCheckers;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BaseNotReadOnlyAssistantChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BlockIsGodModeChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BlockNotReadOnlyOrUserCanEditReadOnlyChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.CanAddBlockChecker;


@Component
@ParametersAreNonnullByDefault
public class RtbBlockActionsCheckers implements BlockActionsCheckers<RtbBlock> {

    private final BlockNotReadOnlyOrUserCanEditReadOnlyChecker blockNotReadOnlyOrUserCanEditReadOnlyChecker;
    private final BaseNotReadOnlyAssistantChecker<RtbBlock> notReadOnlyAssistantChecker;
    private final BlockIsGodModeChecker blockIsGodModeChecker;
    private final CanAddBlockChecker<RtbBlock> canAddBlockChecker;

    @Autowired
    public RtbBlockActionsCheckers(
            BlockNotReadOnlyOrUserCanEditReadOnlyChecker blockNotReadOnlyOrUserCanEditReadOnlyChecker,
            BaseNotReadOnlyAssistantChecker<RtbBlock> notReadOnlyAssistantChecker,
            BlockIsGodModeChecker blockIsGodModeChecker,
            CanAddBlockChecker<RtbBlock> canAddBlockChecker) {

        this.blockNotReadOnlyOrUserCanEditReadOnlyChecker = blockNotReadOnlyOrUserCanEditReadOnlyChecker;
        this.notReadOnlyAssistantChecker = notReadOnlyAssistantChecker;
        this.blockIsGodModeChecker = blockIsGodModeChecker;
        this.canAddBlockChecker = canAddBlockChecker;
    }

    @Override
    public List<ActionChecker<? super RtbBlock>> delete() {
        return List.of(
                blockNotReadOnlyOrUserCanEditReadOnlyChecker,
                notReadOnlyAssistantChecker
        );
    }

    @Override
    public List<ActionChecker<? super RtbBlock>> restore() {
        return List.of(
                blockNotReadOnlyOrUserCanEditReadOnlyChecker,
                notReadOnlyAssistantChecker
        );
    }

    @Override
    public List<ActionChecker<? super RtbBlock>> edit() {
        return List.of(
                blockIsGodModeChecker,
                blockNotReadOnlyOrUserCanEditReadOnlyChecker,
                notReadOnlyAssistantChecker
        );
    }

    @Override
    public List<ActionChecker<? super RtbBlock>> duplicate() {
        return List.of(
                canAddBlockChecker,
                notReadOnlyAssistantChecker
        );
    }
}
