package ru.yandex.partner.jsonapi.crnk.block.rtb.internal;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ForeignFieldDefaultsService;
import ru.yandex.partner.jsonapi.models.block.rtb.internal.ApiInternalRtbModel;
import ru.yandex.partner.jsonapi.models.block.rtb.internal.InternalRtbBlockAccessFunctionComposite;

@Service
public class InternalRtbBlockApiFieldsService extends ApiFieldsService<InternalRtbBlock> {

    private final BlockValidationTypeSupportFacade blockValidationTypeSupportFacade;

    @Autowired
    public InternalRtbBlockApiFieldsService(
            ApiInternalRtbModel apiModel,
            InternalRtbBlockAccessFunctionComposite functionComposite,
            List<ForeignFieldDefaultsService<InternalRtbBlock>> foreignFieldDefaultsServiceList,
            BlockValidationTypeSupportFacade blockValidationTypeSupportFacade) {
        super(apiModel.getApiFieldsAvailableRules(), apiModel.getApiFieldsEditableRules(), apiModel,
                CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME,
                CrnkConstants.EDITABLE_FIELDS_FIELD_NAME,
                functionComposite,
                foreignFieldDefaultsServiceList
        );
        this.blockValidationTypeSupportFacade = blockValidationTypeSupportFacade;
    }

    @Override
    public ModelProperty<? super InternalRtbBlock, ?> getId() {
        return InternalRtbBlock.ID;
    }

    @Override
    public Set<ModelProperty<?, ?>> getPropertiesForValidate(Set<ModelProperty<?, ?>> affectedFields) {
        return blockValidationTypeSupportFacade.getPropertiesForValidate(
                affectedFields,
                getApiModel().getModelClass()
        );
    }
}
