package ru.yandex.partner.jsonapi.crnk.block.rtb.internal.authorization.actions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsCheckers;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BlockIsGodModeChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.CanAddBlockChecker;

@Component
@ParametersAreNonnullByDefault
public class InternalRtbBlockActionsCheckers implements BlockActionsCheckers<InternalRtbBlock> {
    private final BlockIsGodModeChecker blockIsGodModeChecker;
    private final CanAddBlockChecker<InternalRtbBlock> canAddBlockChecker;

    @Autowired
    public InternalRtbBlockActionsCheckers(BlockIsGodModeChecker blockIsGodModeChecker,
                                           CanAddBlockChecker<InternalRtbBlock> canAddBlockChecker) {
        this.blockIsGodModeChecker = blockIsGodModeChecker;
        this.canAddBlockChecker = canAddBlockChecker;
    }

    @Override
    public List<ActionChecker<? super InternalRtbBlock>> delete() {
        return List.of();
    }

    @Override
    public List<ActionChecker<? super InternalRtbBlock>> restore() {
        return List.of();
    }

    @Override
    public List<ActionChecker<? super InternalRtbBlock>> edit() {
        return List.of(blockIsGodModeChecker);
    }

    @Override
    public List<ActionChecker<? super InternalRtbBlock>> duplicate() {
        return List.of(canAddBlockChecker);
    }
}
