package ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.external;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionAuthEntry;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.external.authorization.actions.MobileRtbBlockActionsCheckers;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.external.ApiMobileRtbMetaData;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Service
@ParametersAreNonnullByDefault
public class MobileRtbBlockActionsAuthorizationService extends BlockActionsAuthorizationService<MobileRtbBlock> {

    private final MobileRtbBlockActionsCheckers blockActionsCheckers;


    @Autowired
    public MobileRtbBlockActionsAuthorizationService(MultistateGraph<MobileRtbBlock, BlockStateFlag> graph,
                                                     ApiMobileRtbMetaData apiModelMetaData,
                                                     AuthenticationFacade authenticationFacade,
                                                     MobileRtbBlockActionsCheckers blockActionsCheckers) {
        super(graph, apiModelMetaData, authenticationFacade, blockActionsCheckers);
        this.blockActionsCheckers = blockActionsCheckers;
    }

    @Override
    protected Map<String, ActionAuthEntry<MobileRtbBlock>> getAuthEntryMap() {
        return ActionAuthEntry.buildMap(getApiModelMetaData().getResourceType(), List.of(
                ActionAuthEntry.<MobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.DELETE)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.delete()),
                ActionAuthEntry.<MobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.RESTORE)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.restore()),
                ActionAuthEntry.<MobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.EDIT)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.edit()),
                ActionAuthEntry.<MobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.DUPLICATE)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.duplicate()),
                ActionAuthEntry.<MobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.START)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.start()),
                ActionAuthEntry.<MobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.STOP)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.stop())
        ));
    }

    @Override
    protected boolean isPageProtected(MobileRtbBlock block) throws RuntimeException {
        return block.getCampaign().getMultistate().hasFlag(PageStateFlag.PROTECTED);
    }

    @Override
    protected Long extractPageId(MobileRtbBlock block) {
        return block.getCampaign().getId();
    }
}
