package ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.page.model.PageWithMultistate;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.BlockAuthorizationPolicy;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.ActiveBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.BlockViewRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.MobileRtbBlockByPageRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.TechnicalBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.ZeroBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post.EditProtectedPageRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post.HasAddRule;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.external.ApiMobileRtbMetaData;

@Service
public class MobileRtbBlockAuthorizationPolicy extends BlockAuthorizationPolicy<MobileRtbBlock> {

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public MobileRtbBlockAuthorizationPolicy(
            ApiMobileRtbMetaData apiModelMetaData,
            BlockViewRule blockViewRule,
            ActiveBlockRule activeBlockRule,
            MobileRtbBlockByPageRule blockByPageRule,
            TechnicalBlockRule technicalBlockRule,
            ZeroBlockRule zeroBlockRule,
            HasAddRule hasAddRule,
            EditProtectedPageRule editProtectedPageRule
    ) {
        super(
                apiModelMetaData,
                blockViewRule,
                activeBlockRule,
                blockByPageRule,
                technicalBlockRule,
                zeroBlockRule,
                hasAddRule,
                editProtectedPageRule
        );
    }

    @Override
    public Class<? extends PageWithMultistate> getPageClass() {
        return MobileAppSettings.class;
    }
}
