package ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.external.authorization.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.crnk.action.check.UserSimpleInappActionChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsCheckers;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BaseNotReadOnlyAssistantChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BlockIsGodModeChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BlockNotReadOnlyOrUserCanEditReadOnlyChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.CanAddBlockChecker;

@Component
public class MobileRtbBlockActionsCheckers implements BlockActionsCheckers<MobileRtbBlock> {
    private final UserSimpleInappActionChecker userSimpleInappActionChecker;
    private final CanAddBlockChecker<MobileRtbBlock> canAddBlockChecker;
    private final BlockIsGodModeChecker blockIsGodModeChecker;
    private final BaseNotReadOnlyAssistantChecker<MobileRtbBlock> notReadOnlyAssistantChecker;
    private final BlockNotReadOnlyOrUserCanEditReadOnlyChecker blockNotReadOnlyOrUserCanEditReadOnlyChecker;

    @Autowired
    public MobileRtbBlockActionsCheckers(
            UserSimpleInappActionChecker userSimpleInappActionChecker,
            CanAddBlockChecker<MobileRtbBlock> canAddBlockChecker,
            BlockIsGodModeChecker blockIsGodModeChecker,
            BaseNotReadOnlyAssistantChecker<MobileRtbBlock> notReadOnlyAssistantChecker,
            BlockNotReadOnlyOrUserCanEditReadOnlyChecker blockNotReadOnlyOrUserCanEditReadOnlyChecker
    ) {
        this.userSimpleInappActionChecker = userSimpleInappActionChecker;
        this.canAddBlockChecker = canAddBlockChecker;
        this.blockIsGodModeChecker = blockIsGodModeChecker;
        this.notReadOnlyAssistantChecker = notReadOnlyAssistantChecker;
        this.blockNotReadOnlyOrUserCanEditReadOnlyChecker = blockNotReadOnlyOrUserCanEditReadOnlyChecker;
    }

    @Override
    public List<ActionChecker<? super MobileRtbBlock>> delete() {
        return List.of(
                notReadOnlyAssistantChecker,
                blockNotReadOnlyOrUserCanEditReadOnlyChecker
        );
    }

    @Override
    public List<ActionChecker<? super MobileRtbBlock>> restore() {
        return List.of(
                notReadOnlyAssistantChecker,
                blockNotReadOnlyOrUserCanEditReadOnlyChecker
        );
    }

    @Override
    public List<ActionChecker<? super MobileRtbBlock>> edit() {
        return List.of(
                blockIsGodModeChecker,
                notReadOnlyAssistantChecker,
                blockNotReadOnlyOrUserCanEditReadOnlyChecker
        );
    }

    @Override
    public List<ActionChecker<? super MobileRtbBlock>> duplicate() {
        return List.of(
                canAddBlockChecker,
                notReadOnlyAssistantChecker
        );
    }

    public List<ActionChecker<? super MobileRtbBlock>> start() {
        return List.of(
                userSimpleInappActionChecker
        );
    }

    public List<ActionChecker<? super MobileRtbBlock>> stop() {
        return List.of(
                userSimpleInappActionChecker
        );
    }
}
