package ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.internal;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ForeignFieldDefaultsService;
import ru.yandex.partner.jsonapi.models.AccessFunctionComposite;
import ru.yandex.partner.jsonapi.models.ApiModel;

@Service
public class InternalMobileRtbBlockApiFieldsService extends ApiFieldsService<InternalMobileRtbBlock> {

    private final BlockValidationTypeSupportFacade blockValidationTypeSupportFacade;

    @Autowired
    public InternalMobileRtbBlockApiFieldsService(
            ApiModel<InternalMobileRtbBlock> apiModel,
            AccessFunctionComposite<InternalMobileRtbBlock> functionComposite,
            List<ForeignFieldDefaultsService<InternalMobileRtbBlock>> foreignFieldDefaultsServices,
            BlockValidationTypeSupportFacade blockValidationTypeSupportFacade) {

        super(apiModel.getApiFieldsAvailableRules(), apiModel.getApiFieldsEditableRules(), apiModel,
                CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME,
                CrnkConstants.EDITABLE_FIELDS_FIELD_NAME,
                functionComposite,
                foreignFieldDefaultsServices
        );
        this.blockValidationTypeSupportFacade = blockValidationTypeSupportFacade;
    }

    @Override
    public ModelProperty<? super InternalMobileRtbBlock, ?> getId() {
        return InternalMobileRtbBlock.ID;
    }

    @Override
    public Set<ModelProperty<?, ?>> getPropertiesForValidate(Set<ModelProperty<?, ?>> affectedFields) {
        return blockValidationTypeSupportFacade.getPropertiesForValidate(
                affectedFields,
                getApiModel().getModelClass()
        );
    }
}
