package ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.model.PageWithMultistate;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.BlockAuthorizationPolicy;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.ActiveBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.BlockViewRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.InternalMobileRtbBlockByPageRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.TechnicalBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.get.ZeroBlockRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post.EditProtectedPageRule;
import ru.yandex.partner.jsonapi.crnk.block.rtb.authorization.post.HasAddRule;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.internal.ApiInternalMobileRtbMetaData;

@Service
public class InternalMobileRtbBlockAuthorizationPolicy extends BlockAuthorizationPolicy<InternalMobileRtbBlock> {

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public InternalMobileRtbBlockAuthorizationPolicy(
            ApiInternalMobileRtbMetaData apiModelMetaData,
            BlockViewRule blockViewRule,
            ActiveBlockRule activeBlockRule,
            InternalMobileRtbBlockByPageRule blockByPageRule,
            TechnicalBlockRule technicalBlockRule,
            ZeroBlockRule zeroBlockRule,
            HasAddRule hasAddRule,
            EditProtectedPageRule editProtectedPageRule
    ) {
        super(
                apiModelMetaData,
                blockViewRule,
                activeBlockRule,
                blockByPageRule,
                technicalBlockRule,
                zeroBlockRule,
                hasAddRule,
                editProtectedPageRule
        );
    }

    @Override
    public Class<? extends PageWithMultistate> getPageClass() {
        return InternalMobileApp.class;
    }
}
