package ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.internal.authorization.actions;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionAuthEntry;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsAuthorizationService;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.internal.ApiInternalMobileRtbMetaData;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Service
public class InternalMobileRtbBlockActionsAuthorizationService
        extends BlockActionsAuthorizationService<InternalMobileRtbBlock> {
    private final InternalMobileRtbBlockActionsCheckers blockActionsCheckers;

    @Autowired
    public InternalMobileRtbBlockActionsAuthorizationService(
            ApiInternalMobileRtbMetaData apiModelMetaData,
            MultistateGraph<InternalMobileRtbBlock, BlockStateFlag> graph,
            AuthenticationFacade authenticationFacade,
            InternalMobileRtbBlockActionsCheckers blockActionsCheckers) {
        super(graph, apiModelMetaData, authenticationFacade, blockActionsCheckers);
        this.blockActionsCheckers = blockActionsCheckers;
    }

    @Override
    protected Map<String, ActionAuthEntry<InternalMobileRtbBlock>> getAuthEntryMap() {
        return ActionAuthEntry.buildMap(getApiModelMetaData().getResourceType(), List.of(
                ActionAuthEntry.<InternalMobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.DELETE)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.delete()),
                ActionAuthEntry.<InternalMobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.RESTORE)
                        .setExposed(true)
                        .setRightRequired(true)
                        .setChecks(blockActionsCheckers.restore()),
                ActionAuthEntry.<InternalMobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.EDIT)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.edit()),
                ActionAuthEntry.<InternalMobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.DUPLICATE)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.duplicate()),
                ActionAuthEntry.<InternalMobileRtbBlock>builder()
                        .setActionName(BlockActionsEnum.START)
                        .setExposed(true)
                        .setRightRequired(false)
                        .setChecks(blockActionsCheckers.start())
        ));
    }

    @Override
    protected boolean canEditAll(UserAuthentication ua) {
        return ua.userHasRight(BlockRightNames.EDIT_ALL.getFullRightName(getApiModelMetaData().getResourceType()));
    }

    @Override
    protected boolean isPageProtected(InternalMobileRtbBlock block) {
        return block.getCampaign().getMultistate().hasFlag(PageStateFlag.PROTECTED);
    }

    @Override
    protected Long extractPageId(InternalMobileRtbBlock block) {
        return block.getCampaign().getId();
    }
}
