package ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.internal.authorization.actions;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.jsonapi.crnk.action.check.ActionChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsCheckers;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.BlockIsGodModeChecker;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.check.CanAddBlockChecker;

@Component
@ParametersAreNonnullByDefault
public class InternalMobileRtbBlockActionsCheckers implements BlockActionsCheckers<InternalMobileRtbBlock> {
    private final BlockIsGodModeChecker blockIsGodModeChecker;
    private final CanAddBlockChecker<InternalMobileRtbBlock> canAddBlockChecker;

    @Autowired
    public InternalMobileRtbBlockActionsCheckers(BlockIsGodModeChecker blockIsGodModeChecker,
                                           CanAddBlockChecker<InternalMobileRtbBlock> canAddBlockChecker) {
        this.blockIsGodModeChecker = blockIsGodModeChecker;
        this.canAddBlockChecker = canAddBlockChecker;
    }

    @Override
    public List<ActionChecker<? super InternalMobileRtbBlock>> delete() {
        return List.of();
    }

    @Override
    public List<ActionChecker<? super InternalMobileRtbBlock>> restore() {
        return List.of();
    }

    @Override
    public List<ActionChecker<? super InternalMobileRtbBlock>> edit() {
        return List.of(blockIsGodModeChecker);
    }

    @Override
    public List<ActionChecker<? super InternalMobileRtbBlock>> duplicate() {
        return List.of(canAddBlockChecker);
    }

    public List<ActionChecker<? super InternalMobileRtbBlock>> start() {
        return List.of();
    }

    public List<ActionChecker<? super InternalMobileRtbBlock>> stop() {
        return List.of();
    }
}
